<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * CompanyDistributionSales
 *
 * @ORM\Table(name="company_distribution_sales")
 * @ORM\Entity()
 *
 * @ExclusionPolicy("all")
 * @ORM\HasLifecycleCallbacks
 */
class CompanyDistributionSales
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="company_id", type="integer")
     */
    private $companyId;

    /**
     * @var integer
     *
     * @ORM\Column(name="distribution_sales_id", type="integer")
     */
    private $distributionSalesId;

    /**
     * @var float
     *
     * @ORM\Column(name="value", type="decimal", precision=9, scale=2)
     */
    private $value;

    /**
     * @ORM\ManyToOne(targetEntity="Company",inversedBy="companyDistributionSales")
     * @ORM\JoinColumn(name="company_id", referencedColumnName="id")
     */
    private $company;

    /**
     * @ORM\ManyToOne(targetEntity="DistributionSales",inversedBy="companyDistributionSales")
     * @ORM\JoinColumn(name="distribution_sales_id", referencedColumnName="id")
     */
    private $distributionSales;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set companyId
     *
     * @param integer $companyId
     * @return CompanyDistributionSales
     */
    public function setCompanyId($companyId)
    {
        $this->companyId = $companyId;
    
        return $this;
    }

    /**
     * Get companyId
     *
     * @return integer 
     */
    public function getCompanyId()
    {
        return $this->companyId;
    }

    /**
     * Set distributionSalesId
     *
     * @param integer $distributionSalesId
     * @return CompanyDistributionSales
     */
    public function setDistributionSalesId($distributionSalesId)
    {
        $this->distributionSalesId = $distributionSalesId;
    
        return $this;
    }

    /**
     * Get distributionSalesId
     *
     * @return integer 
     */
    public function getDistributionSalesId()
    {
        return $this->distributionSalesId;
    }

    /**
     * Set value
     *
     * @param string $value
     * @return CompanyDistributionSales
     */
    public function setValue($value)
    {
        $this->value = $value;
    
        return $this;
    }

    /**
     * Get value
     *
     * @return string 
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * Set company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     * @return CompanyDistributionSales
     */
    public function setCompany(\VM\ApiBundle\Entity\Company $company = null)
    {
        $this->company = $company;
    
        return $this;
    }

    /**
     * Get company
     *
     * @return \VM\ApiBundle\Entity\Company 
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Set distributionSales
     *
     * @param \VM\ApiBundle\Entity\DistributionSales $distributionSales
     * @return CompanyDistributionSales
     */
    public function setDistributionSales(\VM\ApiBundle\Entity\DistributionSales $distributionSales = null)
    {
        $this->distributionSales = $distributionSales;
    
        return $this;
    }

    /**
     * Get distributionSales
     *
     * @return \VM\ApiBundle\Entity\DistributionSales 
     */
    public function getDistributionSales()
    {
        return $this->distributionSales;
    }
}